/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;

public class TargetActionOnHitPower
extends CooldownPower {
    private final Predicate<Tuple<DamageSource, Float>> damageCondition;
    private final Predicate<LivingEntity> targetCondition;
    private final Consumer<Entity> entityAction;

    public TargetActionOnHitPower(PowerType<?> type, PlayerEntity player, int cooldownDuration, HudRender hudRender, Predicate<Tuple<DamageSource, Float>> damageCondition, Consumer<Entity> entityAction, Predicate<LivingEntity> targetCondition) {
        super(type, player, cooldownDuration, hudRender);
        this.damageCondition = damageCondition;
        this.entityAction = entityAction;
        this.targetCondition = targetCondition;
    }

    public void onHit(LivingEntity target, DamageSource damageSource, float damageAmount) {
        if ((this.targetCondition == null || this.targetCondition.test(target)) && (this.damageCondition == null || this.damageCondition.test((Tuple<DamageSource, Float>)new Tuple((Object)damageSource, (Object)Float.valueOf(damageAmount)))) && this.canUse()) {
            this.entityAction.accept((Entity)target);
            this.use();
        }
    }
}

